Public Class FuelSystem

  Public Enum ThrottleSetting
    Idle
    Cruise
    Accelerate
  End Enum

  Private FThrottle As ThrottleSetting

  Public Property Throtte() As ThrottleSetting

    Get
      Return FThrottle
    End Get

    Set(ByVal Value As ThrottleSetting)
      FThrottle = Value
      Debug.WriteLine(Value)
    End Set

  End Property

End Class

Public Class Stove

  Private FTemperature As Double

  Public Property Temperature() As Double

    Get
      Return FTemperature
    End Get

    Set(ByVal Value As Double)
      Debug.Assert(Value < 400 And Value >= 0)
      If (FTemperature >= 400) Then Exit Property
      FTemperature = Value
      Debug.WriteLine(FTemperature)
    End Set

  End Property

End Class

Public Class IndexedException
  Inherits ApplicationException

  Public Sub New(ByVal Str As String)
    MyBase.New(Str)
  End Sub

  Public Shared Sub ThrowException(ByVal Index As Integer)
    Throw New IndexedException(Index & " is an invalid index")
  End Sub

End Class

Public Class Indexed

  Private FStrings() As String = {"Jeden", "Dwa", "Trzy"}

  Default Public Property Strings(ByVal Index As Integer) As String
    Get
      Return FStrings(Index)
    End Get

    Set(ByVal Value As String)
      FStrings(Index) = Value
    End Set
  End Property

  Private Sub Swap(ByVal OldIndex As Integer, _
    ByVal NewIndex As Integer)

    Dim Temp As String = FStrings(NewIndex)
    FStrings(NewIndex) = FStrings(OldIndex)
    FStrings(OldIndex) = Temp
  End Sub

  Private Function ValidIndex(ByVal Index As Integer) As Boolean
    Return (Index >= FStrings.GetLowerBound(0)) And _
      (Index <= FStrings.GetUpperBound(0))
  End Function

  Private Overloads Sub Validate(ByVal Name As String)
    Validate(Names(Name))
  End Sub

  Private Overloads Sub Validate(ByVal Index As Integer)
    If (Not ValidIndex(Index)) Then
      'Throw New ApplicationException(Index & " jest niepoprawnym indeksem")
      IndexedException.ThrowException(Index)
    End If
  End Sub

  Public Property Names(ByVal Name As String) As Integer
    Get
      Return Array.IndexOf(FStrings, Name)
    End Get

    Set(ByVal Value As Integer)
      Swap(Names(Name), Value)
    End Set
  End Property

End Class

Public Class PropertyModifiers

  Public Shared ReadOnly Property Name() As String
    <System.Diagnostics.DebuggerHidden()> Get
      Return "PropertyModifiers"
    End Get
  End Property

  Private FPassword As String

  Public WriteOnly Property Password() As String
    Set(ByVal Value As String)
      FPassword = Value
    End Set
  End Property

  Public Sub New()
    MyBase.New()
    FCreateTime = Now
  End Sub

  Private FCreateTime As Date
  Public ReadOnly Property CreateTime() As Date
    Get
      Return FCreateTime
    End Get
  End Property

  Public ReadOnly Property ElapsedTime() As TimeSpan
    Get
      Return Date.op_Subtraction(Now, FCreateTime)
    End Get
  End Property

  Protected Overrides Sub Finalize()
    MsgBox("Finalize")
  End Sub
End Class

Public Class Constructor
  Implements IDisposable

  Public Sub Dispose() Implements IDisposable.Dispose
    MsgBox("Dispose")
  End Sub

End Class